clearvars
c_parameters_immune_oned

L = 10;
T_pde = 1000;
maxit = 1;
delta = 0.05;
tau = 0.01;
dx = 0.05;
dt = 1e-3;
cell_uninf = Ru;
h_uninf = 0.9 * K;

space = [-L L];

chiT = chiT / 10;
zU = zU / 2;
S_z = 0.05;

tic
c_pde_immune_oned
time_pde = toc;

tic
seed = 1;
rng(seed)
c_agents_immune_oned
time_agents = toc;

U_plot = U;
Tcell_plot = Tcell;
c_plot = c;

h = figure(1); clf
vid = VideoWriter('video');
vid.FrameRate = 4;
c_video_oned_immune

figure(2)
clf
U_sum = sum(U);
T_sum = sum(Tcell);
u1_sum = sum(u1') * dx;
u3_sum = sum(u3') * dx;

plot(0:T_pde, U_sum, 'LineWidth', 2)
hold on
plot(0:T_pde, T_sum, 'LineWidth', 2)
hold on
plot(0:T_pde, u1_sum, 'k:', 'LineWidth', 2)
hold on
plot(0:T_pde, u3_sum, 'k:', 'LineWidth', 2)

axis([0 T_pde 0 max(u1_sum)])

legend('Uninfected', 'Immune', 'Location', 'northwest')
